<?php
session_start();

include("./params.inc.php");
include("./lib/xmlrpc.inc");

$GLOBALS['xmlrpc_internalencoding']='UTF-8';

//Read the document and delete the temporary file
$doc_content = null;
$doc_name = null;
if ($_FILES['document']['size'] == 0) {
	//no document, use the default one
	$doc_name="default-contract.pdf";
	$doc_content=file_get_contents($doc_name);

} else {
	$doc_filename=$_FILES['document']['tmp_name'];
	$doc_content=file_get_contents($doc_filename);
	$doc_name=basename($_FILES['document']['name']);
	if (is_uploaded_file($doc_filename)) {
		unlink($doc_filename);
	}
}

//retrieve the return url
$returnPage = (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
$returnPage .= $_SERVER["SERVER_NAME"] . ":" . $_SERVER["SERVER_PORT"] . dirname($_SERVER["REQUEST_URI"]);
$returnPage .= "/return.php?id=";

//create the request
$c = new xmlrpc_client($uni_url);

$signer = array(
	"firstname" => new xmlrpcval(trim($_REQUEST["firstname"]), "string"),
	"lastname" => new xmlrpcval(trim($_REQUEST["lastname"]), "string"),
	// the return urls
	"successURL" =>  new xmlrpcval($returnPage."success", "string"),
	"failURL" =>  new xmlrpcval($returnPage."fail", "string"),
	"cancelURL" =>  new xmlrpcval($returnPage."cancel", "string"),
	// position of the signature field
	"signatureField" => new xmlrpcval(array(
		"page" => new xmlrpcval(1, "int"),
		"x" => new xmlrpcval(50, "int"),
		"y" => new xmlrpcval(10, "int")
	), "struct")
);

if ($_REQUEST["email"] != null) {
	$signer["emailAddress"] = new xmlrpcval($_REQUEST["email"], "string");
}

$language = "fr";
if ($_REQUEST["language"] != null) {
	$language = $_REQUEST["language"];
}

if ($_REQUEST["profile"] != null) {
	$uni_profile = $_REQUEST["profile"];
}

if ($_REQUEST["redirectTo"] != null) {
	$_SESSION['uni_redirectTo'] =  $_REQUEST["redirectTo"];
}
$hand = 0;
if (isset($_REQUEST["hand"]) && $_REQUEST["hand"] == "true" ) {
	$hand = 1;
} 


$request = array(
	"documents" => new xmlrpcval(array(
		//array of documents to sign
		new xmlrpcval(array(
			"content" => new xmlrpcval($doc_content, "base64"),		
			"name" => new xmlrpcval($doc_name, "string")		
		), "struct")
	), "array"),
	"signers" =>  new xmlrpcval(array(
		new xmlrpcval($signer, "struct"),
	), "array"),
	//handwritten
	"handwrittenSignature" =>  new xmlrpcval($hand, "boolean"),
	// the profile to use
	"profile" =>  new xmlrpcval($uni_profile, "string"),
	//the types of acceptected certificate : simple | certified
	"certificateType" =>  new xmlrpcval($_REQUEST["certType"], "string"),
	"language" => new xmlrpcval($language, "string")
);


$f = new xmlrpcmsg('requester.requestTransaction', array(new xmlrpcval($request, "struct")));

//SSL verification (should be enabled in production)
$c->setSSLVerifyHost(1);
$c->setSSLVerifyPeer(1);

//Debug flag
$c->setDebug(0);

//Send request an analyse response
$r=&$c->send($f);
if(!$r->faultCode()) {
	//request successul: store the ID in the session and redirects to the URL
	$url = $r->value()->structMem('url')->scalarVal();
	$_SESSION['uni_id'] = $r->value()->structMem('id')->scalarVal();
	header("Location: ".$url);
} else {
	//error
	print "An error occurred: ";
	print "Code: " . $r->faultCode()
		. " Reason: '" . $r->faultString();
}
?>
